import React from "react";
import { createDrawerNavigator } from "@react-navigation/drawer";
import TabNavigation from "./TabNavigation";
import MyWishlist from "../../screens/MyWishlist/MyWishlist";
import DrawerContainer from "./DrawerContainer/DrawerContainer";
import TrackOrderInput from "../../screens/TrackOrder/TrackOrderInput";
import PrivateRoute from "./PrivateRoute/PrivateRoute";

const Drawer = createDrawerNavigator();

const DrawerStack = () => {
    return (
        <Drawer.Navigator
            screenOptions={{
                headerShown: false,
            }}
            drawerContent={(props) => <DrawerContainer {...props} />}
        >
            <Drawer.Screen name='HomeScreen' component={TabNavigation} />
            <Drawer.Screen name='my wishlist'>
                {(props) => (
                    <PrivateRoute>
                        <MyWishlist {...props} />
                    </PrivateRoute>
                )}
            </Drawer.Screen>
            <Drawer.Screen
                name='track your order'
                component={TrackOrderInput}
            />
        </Drawer.Navigator>
    );
};
export default DrawerStack;
